<?php

$receiptRoute = "(?:" . UDASH_ROUTE . "|" . UADMIN_ROUTE . ")/receipt/\w+";

Uss::route( $receiptRoute, function() {

    new class {

        public $data;
        public $date;
        public $currency;
        public $sender;
        public $receiver;
        public $user;
        public $senderName;

        public function __construct() {

            $this->prepare();
            $this->render();

        }

        public function prepare() {

            $this->data = Bank::getTransaction( Uss::query(2), 'tx_ref' );

            if( !$this->data ) {
                return;
            };
            
            $this->user = Uss::$global['user'];
            $this->date = (new Datetime())->format("jS/m/Y i:m:s");
            $this->currency = Bank::getCurrencies( $this->data['transfer']['currency'] );
            $this->sender = Bank::getBankUser( $this->data['sender'] ? $this->data['sender']['account_number'] : null );
            $this->receiver = Bank::getBankUser( $this->data['receiver'] ? $this->data['receiver']['account_number'] : null );

            $this->senderName = $this->data['transfer']['sender_name'];

            if( !$this->senderName ) {
                $this->senderName = $this->getBio('sender', 'firstname' ) . ' ' . $this->getBio('sender', 'lastname');
            };

        }

        public function render() {

            Udash::config('blank', true);

            Bank::resetOptionTags();

            Events::addListener('@head:before', function() {
                echo "<style>
                    @media print {
                        button.btn {
                            display: none;
                        }
                    }
                </style>";
            }, 'print-receipt');

            Udash::view(function() {

                if( !$this->data ) {
                    return Udash::empty_state("There is no such transaction with the given reference ID");
                };

                echo $this->buildReceipt();

            });

        }

        public function buildReceipt() {
            return <<<RECEIPT
                <div class='py-5 container'>

                    <div class='row'>     
                        <div class='col-lg-8 mx-auto'>

                            <div class='card rounded-0 mb-4'>
                                <div class='card-body'>

                                    <div class='p-5'>

                                        <figure class='text-center'>
                                            <img src='%{@site:icon}' class='' height='80px'>
                                        </figure>

                                        <div class='text-center mb-4'>
                                            <h4 class='mb-3'>Transaction Receipt</h4>
                                            <p class='text-muted'>Generated from %{@site:title} on {$this->date}</p>
                                        </div>

                                        <table class='table mb-5 text-capitalize'>
                                            <tbody>
                                                {$this->tableContent()}
                                            </tbody>
                                        </table>

                                        <div class=''>

                                            <p class='fs-14px mb-3'>If you have any questions or would like more information, please call our 24-hour Contact Centre on <a href='tel:%{@site:phone}'>%{@site:phone}</a> or send an email to 
                                            <a href='mailto:%{@email:admin}'>%{@email:admin}</a></p>

                                            <p class='mb-3'>Thank you for choosing %{@site:title}</p>

                                            <p class='text-muted'>Banking with %{@site:title}: Branch | ATM | Online | Mobile | Contact centre</p>

                                        </div>

                                    </div> <!-- / p-5 -->

                                </div>
                            </div> <!-- /card -->

                            <button class='btn btn-primary btn-lg w-100' onclick='window.print()'>
                                <i class='bi bi-printer me-1'></i> Print Receipt
                            </button>

                        </div>
                    </div> <!-- /row -->

                </div>
            RECEIPT;
        }

        public function tableContent() {
            
            $info = [
                'transaction amount' => $this->currency['symbol'] . number_format($this->data['transfer']['amount'], 2),
                'transaction type' => ( $this->sender && $this->sender['id'] == $this->user['id'] ) ? "Debit" : "Credit",
                'transaction date' => (new DateTime($this->data['transfer']['tx_date']))->format("jS-m-Y H:i"),
                'sender' => $this->senderName,
                'beneficiary' => "
                    {$this->data['transfer']['bank_holder']} 
                    {$this->data['transfer']['bank_account']}
                    {$this->data['transfer']['bank_name']}
                ",
                "transaction reference" => $this->data['transfer']['tx_ref'],
                "transaction status" => $this->data['transfer']['tx_status']
            ];

            
            if( $this->data['transfer']['tx_region'] != 'local' ) {
                $info['region'] = $this->data['transfer']['tx_region'];
                $country = Udash::countries($this->data['transfer']['bank_country']);
                $info['country'] = $country;
                $identifier = $this->data['transfer']['identifier'];
                $info[ $identifier ] = $this->data['transfer']['identifier_code'];
            };

            $body = '';

            foreach( $info as $key => $value ) {
                $value = nl2br($value);
                $body .= "
                    <tr>
                        <th><span class=''>{$key}</span></th>
                        <td><span class='text-primary'>{$value}</span></td>
                    </tr>
                ";
            };

            return $body;

        }

        protected function getBio( string $prop, string $key, ?string $value = null ) {
            $client = $this->{$prop};
            if( !$client ) {
                return $value;
            };
            $client = Uss::$global['usermeta']->get("bank:info", $client['id']);
            if( !$client ) {
                return $value;
            };
            $client = $client['bio'] ?? [];
            return $client[$key] ?? $value;
        }

    }; // End Class

}); // End Route

