<?php

    // Account Number;
    $bankNo = Uss::$global['usermeta']->get('bank:number', Uss::$global['user']['id']);

    // Local or International
    $intl = Uss::query(2) != 'local'; // true | false;

?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            
            <div class="card">
                <div class="card-body">

                    <div class='p-lg-5'>

                        <h3 class='mb-4'><?php echo $intl ? "International" : "Local"; ?> Transfer</h3>

                        <div class="card bg-secondary p-3 text-light mb-4">

                            <div class='d-flex align-item-base'>

                                <div class='left w-100'>
                                    <h4>Balance:</h4>

                                    <h1 class="display-6 text-light">
                                        %{user.currency}<span data-area='balance' class=''>%{user.balance}</span>
                                        <span data-area='asterik' class='d-none'>****</span>
                                    </h1>
                                </div>

                                <div class='right'>
                                    <a class='text-light fs-24px' id='eyedrop' href='javascript:void(0)'>
                                        <i class='bi bi-eye'></i>
                                    </a>
                                </div>
                            
                            </div>

                            <hr>

                            <p><strong>Account Number:</strong> %{user.bank_number}</p>
                            
                        </div>

                        <!-- The form -->

                        <div class=''>

                            <div class='text-end border-bottom pb-2 mb-4'>
                                <?php echo (new DateTime())->format("dS-M-Y"); ?>
                            </div>

                            <form method='POST' id='transfer-form'>

                                <div class=''>

                                    <label class='form-label'>Amount</label>

                                    <div class='input-group mb-1'>
                                        <span class='input-group-text'>%{user.currency}</span>
                                        <input type='text' class='form-control' data-amount required pattern='^\d[\d\,\.]*$'>
                                        <input type='hidden' name='amount' value='0'>
                                    </div>

                                    <div class='border-bottom pb-1 text-end'>
                                        <small class='text-muted'>Charges <i class='bi bi-caret-right'></i></small>
                                        %{user.currency}<small class='text-danger ms-1' data-charge>0.00</small>
                                    </div>

                                </div>

                                <div class='account-area py-3'>

                                    <div class='mb-3 text-center'>
                                        <button class='btn btn-sm btn-outline-danger' type='button' id='finder'>
                                            <i class='bi bi-person-circle me-1'></i> Find Beneficiary
                                        </button>
                                    </div>

                                    <div class='mb-3'>
                                        <label class='form-label'>Bank Name</label>
                                        <input type='text' class='form-control' name='bank_name' required>
                                    </div>

                                    <div class='mb-3'>
                                        <label class='form-label'>Account Number</label>
                                        <input type='number' class='form-control' name='bank_account' required>
                                    </div>

                                    <div class='mb-3'>
                                        <label class='form-label'>Account Holder</label>
                                        <input type='text' class='form-control' name='bank_holder' required>
                                    </div>

                                    <?php if( $intl ): ?>

                                        <div class='px-2'>

                                            <div class='mb-4 pt-3'>
                                                <label class='form-label'>Account Country</label>
                                                <select name='bank_country' class='form-select'>
                                                    %{countries}
                                                </select>
                                            </div>

                                            <div class='mb-4'>
                                                <label class='form-label'>Select Identifier</label>
                                                <select class='form-select' name='identifier' required>
                                                    <?php 

                                                        $identifier = [
                                                            "BIC/Swift Code",
                                                            "Routing Number / Bank Code",
                                                            "IBAN"
                                                        ];

                                                        $identifier = ['' => '-- Select --'] + array_combine( $identifier, $identifier );

                                                        Bank::array_to_options($identifier);

                                                    ?>
                                                </select>
                                            </div>

                                            <div class='mb-4 d-none' id='identifier'>
                                                <label class='form-label'>Enter <span data-identifier></label>
                                                <input type='text' class='form-control' name='identifier_code' required>
                                            </div>

                                        </div>

                                    <?php endif; ?>

                                    <div class='mb-4'>
                                        <div class='form-check form-switch toggle-switch'>
                                            <label class='form-check-label fs-18px'>Save Beneficiary</label>
                                            <input type='checkbox' class='form-check-input' name='save_receiver'>
                                        </div>
                                    </div>

                                    <hr/>

                                    <div class='mb-3'>
                                        <label class='form-label'>Details</label>
                                        <textarea class='form-control resize-none' rows='5' placeholder='Reason for transfer' name='tx_reason'></textarea>
                                    </div>
                                    
                                    <?php if( $intl ): ?>
                                        <div class='mb-3'>
                                            <div class='mt-4 mb-3 border-top'></div>
                                            <div class='form-check'>
                                                <input type='checkbox' class='form-check-input' required>
                                                <label class='form-check-label'>
                                                    I agree with terms and conditions of international transfer
                                                </label>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                </div>

                                <input type='hidden' name='currency' value='%{user.currency.code}'>

                                <button class='btn btn-success w-100'>
                                    Transfer
                                </button>

                            </form>

                        </div>

                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

<template id='ben-template'>
    <div class='d-flex p-3 mb-2 border' data-beneficiary>
        <div class='me-3'>
            <div class='border rounded-circle p-2 text-bg-light'>
                <span data-tag>AA</span>
            </div>
        </div>
        <div class='flex-grow-1 d-flex justify-content-between'>
            <div class=''>
                <h6 class='text-uppercase' data-send='bank_holder'></h6>
                <div>
                    <span data-send='bank_name'></span> -
                    <span data-send='bank_account'></span>
                </div>
            </div>
            <?php if( $intl ): ?>
                <div class=''>
                    <div class='text-bg-info p-2'>
                        <span data-send='bank_country'></span>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class='d-none'>
            <span data-send='identifier'></span>
            <span data-send='identifier_code'></span>
        </div>
    </div>
</template>