<?php

class AbstractHelper extends AbstractTransfer {
        
    # The helper Constructor

    public function __construct() {

        parent::__construct(); # View Parent Class for Configuration

        # Update data from AbstractTransfer Class

        $this->bankinfo = Uss::$global['usermeta']->get('bank:info', $this->user['id']);

        $this->user['currency'] = Bank::getCurrencies( $this->bankinfo['system']['currency'] );

        $this->user['balance'] = Bank::getUserBalance( $this->user['id'], $this->user['currency']['code'] );

        $this->user['bank_number'] = $this->usermeta->get('bank:number', $this->user['id']);

    }

    
    # Set a Template

    public function setTemplate( string $template ) {

        return !!( $this->template = $template ); // returns true

    }


    # Get the Required Template;

    public function getTemplate( ?string $template = null, bool $buildTags = false ) {

        if( empty($template) ) $template = $this->template;
        
        # Define the template file;
        $template = $this->dir . "/template/{$template}";

        # Reset Tags
        if( $buildTags ) $this->buildTags();

        # Return Template File Path
        return $template;

    }


    # log: Print an output on Modal

    public function log( string $type, string $message ) {

       return Bank::log( $type, $message );

    }


    # Check if User is required to confirm an OTP

    public function requiresOTP( string $key ) {

        $bankOTP = Uss::$global['usermeta']->get("bank:otp", $this->user['id']);

        return !empty($bankOTP[$key]);
        
    }


    # Convert Regular Context to X2Client Format

    public function X2Client( string $mailBody ) {

        $mailBody = preg_replace_callback("#\<(\/?)(?!x2\:)(\w+)#", function($match) {
            $value = $match[1];
            return "<{$match[1]}x2:{$match[2]}";
        }, $mailBody);
        
        $X2Client = new X2Client( $mailBody );
        
        $mailBody = $X2Client->render();

        return $mailBody;

    }


    # Test For Localhost Only

    public function localTesting( $PHPMailer ) {

        if( $_SERVER['SERVER_NAME'] === 'localhost' ) {

            $PHPMailer->isSMTP();
            $PHPMailer->SMTPAuth = false;
            $PHPMailer->Host = 'localhost'; // MailHog SMTP Server Address
            $PHPMailer->Port = 1025; // MailHog SMTP Server Port

        };

    }

    
    # Build Transaction Tags

    protected function buildTags() {

        $array = [
            "nonce" => Uss::nonce( $this->noncekey ),
            "bundle" => $this->encodeTransaction( $this->bundle ),
            "transaction" => $this->encodeTransaction( $this->post )
        ];

        $transactionTrackerInputFields = "";

        foreach( $array as $key => $value ) {

            /**
             * For a single value within a form, you can use 
             *
             * - %{encodedNonce}
             * - %{encodedBundle},
             * - %{encodedTransaction}
             * 
             * And so on...
             */
            $tag = "encoded" . ucfirst($key);

            Uss::tag($tag, $value);

            # Build Transaction Input

            $transactionTrackerInputFields .= "<input type='hidden' name='{$key}' value='{$value}'>\n";

        };

        /**
         * To save time and effort, a tracker input shall be created
         * Hence, you can track transaction in post using the tag:
         * 
         * - %{transactionTrackerInputFields}
         */
        Uss::tag('transactionTrackerInputFields', $transactionTrackerInputFields);
        
        # Other Tags;

        Uss::tag('transferURL', Core::url( ROOT_DIR . "/" . implode("/", Uss::query())));
        
    }

}