<?php

$appRoute = $loanRoute . "/application";

$appMenu = $loanMenu->add("application", [
    "label" => "application",
    "href" => Core::url( ROOT_DIR . "/{$appRoute}" )
]);

# Focus

Uss::route( $appRoute, function() use($appMenu) {

    $appMenu->setAttr('active', true);
    $appMenu->parentMenu->setAttr('active', true);

    # Post Request;
    Loan::ManageLoan();

    Udash::view(function() {

        $loanTypes = ['student loan', 'business loan', 'individual loan'];
        $loanTypes = array_combine($loanTypes, $loanTypes);

        $loanDuration = [
            '1 week',
            '2 weeks',
            '1 month',
            '3 months',
            '1 year'
        ];
        $loanDuration = array_combine($loanDuration, $loanDuration);

?>
        
    <div class='container-fluid'>
        <div class='row'>
            <div class='col-lg-9 mx-auto'>

                <div class='card'>
                    <div class='card-body'>
                        <div class='p-3 p-sm-5'>

                            <h4 class='mb-4'>Loan Application</h4>

                            <form method='POST'>
                                <fieldset>

                                    <div class='mb-4'>
                                        <label class='form-label'>Amount</label>
                                        <div class='input-group'>
                                            <span class='input-group-text'>%{user.currency}</span>
                                            <input type='number' step='0.01' class='form-control' name='amount' required>
                                        </div>
                                    </div>

                                    <div class='mb-4'>
                                        <label class='form-label'>Type</label>
                                        <select class='form-select text-capitalize' name='loan_type'>
                                            <?php Bank::array_to_options( $loanTypes ); ?>
                                        </select>
                                    </div>

                                    <div class='mb-4'>
                                        <label class='form-label'>Duration</label>
                                        <select class='form-select text-capitalize' name='duration'>
                                            <?php Bank::array_to_options( $loanDuration ); ?>
                                        </select>
                                    </div>

                                    <div class='mb-4'>
                                        <label class='form-label'>Reason</label>
                                        <textarea class='form-control' name='reason' rows='4'></textarea>
                                    </div>
                                    
                                    <div class='mb-4'>
                                        <button class='btn btn-primary w-100'>
                                            Submit
                                        </button>
                                    </div>

                                </fieldset>
                            </form>
                        
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

<?php   });

}, null);