<?php

defined("BANK_DIR") OR DIE;

$securityMenu = Uss::$global['menu']->add('security', array(
    "label" => "Security",
    "icon" => "<i class='bi bi-lock'></i>",
    "order" => 2
));

# require password

foreach( ['password', 'pin'] as $key ) {

    call_user_func(function() use($key, $securityMenu) {

        $PASS_ROUTE = UDASH_ROUTE . "/account/{$key}";
        
        # Create Sub-Menu

        $menu = $securityMenu->add("{$key}", array(
            "label" => "{$key}",
            "href" => Core::url( ROOT_DIR . "/{$PASS_ROUTE}" )
        ));

        # Focus On URI

        Uss::route( $PASS_ROUTE, function() use($key, $menu) {

            # Activate Menu;

            $menu->setAttr('active', true);
            $menu->parentMenu->setAttr('active', true);

            # Handle Post Request;

            if( Uss::$global['user'] ) {
                # Handle Security 
                require_once __DIR__ . "/post/for-security.php";
            };

            # Security Name;

            Uss::tag('passname', $key);

            # Display Dashboard
            
            Udash::view(function() {

                require_once __DIR__ . "/templates/password-template.html";

            });

        }, null);

    });

};
