<?php

// KYC

$kycRoute = $accountRoute . "/kyc";

$kycMenu = Uss::$global['menu']->get('profile')->add("kyc", [
    "label" => "KYC",
    "href" => Core::url( ROOT_DIR . "/{$kycRoute}" )
]);

# Focus

Uss::route( $kycRoute, function() use($kycMenu) {

    $kycMenu->setAttr('active', true);
    $kycMenu->parentMenu->setAttr('active', true);
    
    require_once ACC_DIR . "/post/kyc.php";

    Udash::view(function() {

        $account = Uss::$global['usermeta']->get('bank:account', Uss::$global['user']['id']);

        if( !empty($account['kyc']) ) {
            $image = Core::url( MOD_DIR . "/{$account['kyc']}" );
            Uss::tag('kyc', $image);
            Uss::tag('disabled', 'disabled');
        };

        require_once ACC_DIR . "/templates/kyc.php";

    });

}, null);
