<div class='container-fluid'>

    <h3 class='border-bottom display-6 pb-3'>Currencies</h3>

    <div class='border-bottom pb-2 text-end mb-3'>
        <a href='<?php echo $coinObject->url . "/new"; ?>' class='btn btn-success'>
            Add new Currency
        </a>
    </div>

    <div class='row'>
        
        <?php 
            
            foreach( $currencies as $key => $currency ): 

                if($currency['code'] == 'USD') {
                    $editURL = $deleteURL = 'javascript:void(0)';
                    $class = 'disabled';
                } else {
                    $editURL = $coinObject->url . "/edit/{$key}";
                    $deleteURL = "?remove={$key}";
                    $class = '';
                };

        ?>

        <div class='col-md-4 col-sm-6 mb-3'>
            <div class='card'>
                <div class='card-body'>
                    <h4 class='border-bottom pb-2 mb-2 fw-normal'>
                        <?php echo $currency['name']; ?> ( <?php echo $currency['code']; ?> )
                    </h4>
                    <div class='fs-20px border-bottom pb-2 mb-2'>
                        <span class='text-danger me-2'>Rate:</span> 
                        <?php echo $currency['symbol'] . number_format($currency['rate'], 2); ?> 
                        <span class='text-primary'>/ $</span>
                    </div>
                    <div class='row row-cols-2'>
                        <div class='col'>
                            <a class='btn btn-primary w-100 <?php echo $class; ?>' href='<?php echo $editURL; ?>'>
                                Edit
                            </a>
                        </div>
                        <div class='col'>
                            <a class='btn btn-danger w-100 <?php echo $class; ?>' href='<?php echo $deleteURL; ?>' data-uss-confirm='Caution!!! <br/> The <span class="text-danger"><?php echo $currency['code']; ?></span> currency will be deleted'>
                                Delete
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php endforeach; ?>

    </div>
</div>