<?php

Events::addListener('uadmin:pages/index', function() {

    $panels = array();

    $panels['users'] = array(
        "color" => "primary",
        "icon" => "bi bi-person",
        "title" => "Total Users",
        "value" => call_user_func(function() {
            $SQL = SQuery::select( DB_TABLE_PREFIX . "_users" );
            return Uss::$global['mysqli']->query( $SQL )->num_rows;
        })
    );
    
    $getTransfer = function($type) {
        $SQL = sprintf( "SELECT SUM(amount) as total FROM %s WHERE tx_type = '{$type}'", DB_TABLE_PREFIX . "_transfer_meta" );
        $result = Uss::$global['mysqli']->query( $SQL )->fetch_assoc();
        return round($result['total'], 2);
    };

    $cashier = function($type, $color, $icon) use(&$panels, $getTransfer) {
        $panels[$type] = array(
            "color" => $color,
            "icon" => "bi bi-{$icon}",
            "title" => ucwords("Total {$type}s"),
            "value" => call_user_func(function() use($type, $getTransfer) {
                $total = $getTransfer($type);
                return "$" . number_format($total, 2);
            })
        );
    };

    $cashier("debit", 'danger', 'box-arrow-left');
    $cashier("credit", "success", "box-arrow-in-down-left");

    $panels['transactions'] = array(
        "color" => "info",
        "title" => "Transactions",
        "icon" => 'bi bi-piggy-bank',
        "value" => call_user_func(function() use($panels, $getTransfer) {
            $value = $getTransfer('credit') + $getTransfer('debit');
            return "$" . number_format($value, 2);
        })
    );

    $getDeposits = function($type = null, $color, $icon) use(&$panels) {
        $panels["{$type}-deposit"] = array(
            "color" => $color,
            "icon" => "bi bi-{$icon}",
            "title" => trim("{$type} deposits"),
            "value" => call_user_func(function() use($type) {
                $SQL = sprintf(
                    "SELECT SUM(usd_amount) AS total FROM %s WHERE status %s '{$type}'",
                    DB_TABLE_PREFIX . "_deposits",
                    is_null($type) ? "<>" : "="
                );
                $result = Uss::$global['mysqli']->query( $SQL )->fetch_assoc();
                return "$" . number_format($result['total'] ?? 0, 2);
            })
        );
    };

    $getDeposits(null, "success", "bank");
    $getDeposits('pending', "warning", "cash-coin");
    $getDeposits('declined', "danger", "exclamation-circle");

?>
<div class='container-fluid'>
    <div class='row'>

        <?php 
            foreach( $panels as $panel ):
        ?>
        <div class='col-xl-3 col-lg-4 col-sm-6 mb-3'>
            <div class='card'>
                <div class='card-body'>
                    <div class='row align-items-center'>
                        <div class='col-4 fs-20px'>
                            <div class='border p-1 text-center rounded-2'>
                                <div class='border text-bg-<?php echo $panel['color']; ?> text-center p-1 rounded-2'>
                                    <i class='bi bi-<?php echo $panel['icon']; ?>'></i>
                                </div>
                            </div>
                        </div>
                        <div class='col-8 ps-0'>
                            <h5 class='mb-1 text-capitalize text-truncate'><?php echo $panel['title']; ?></h5>
                            <div><?php echo $panel['value']; ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>

    </div>
</div>
<?php });