<?php

$manageGatewayRoute = $gatewayRoute . "/manage";

$manageGatewayMenu = $gatewayMenu->add('manage', [
    "label" => "Manage gateways",
    "href" => Core::url( ROOT_DIR . "/{$manageGatewayRoute}" )
]);

# Focus;

Uss::route( $manageGatewayRoute, function() use($manageGatewayMenu) {

    $manageGatewayMenu->setAttr('active', true);
    $manageGatewayMenu->parentMenu->setAttr('active', true);

    # Delete Gateway!

    $id = (int)($_GET['remove'] ?? 0);

    $SQL = SQuery::delete( DB_TABLE_PREFIX . "_payment_methods", "id = {$id}" );

    Uss::$global['mysqli']->query( $SQL );

    # View List

    Udash::view(function() {

        $Tablet = new DOMTablet( 'manage-gateway' );
        
        $SQL = SQuery::select( DB_TABLE_PREFIX . "_payment_methods", "1 ORDER BY id DESC" );
        $result = Uss::$global['mysqli']->query( $SQL );

        $Tablet->data( $result );

        $Tablet->columns([
            "medium" => 'type',
            "network" => "abbr",
            "name",
            "icon",
            "status",
            "action" => ''
        ]);

        $Tablet->wrap('container-fluid');

        $Tablet->prepare(function($data) {

            $status = $data['status'] ? "<i class='bi bi-check-circle text-success'></i>" : "<i class='bi bi-x-lg text-danger'></i>";
            $data['status'] = $status;
            
            if( !empty($data['icon']) ) {
                $icon = Core::url( MOD_DIR . "/{$data['icon']}" );
                $data['icon'] = "<img src='{$icon}' class='img-fluid img-thumbnail' width='60px'>";
            } else $data['icon'] = "<i class='bi bi-x'></i>";

            if( empty($data['network']) ) $data['network'] = "<i class='bi bi-question-circle'></i>";
            
            $href = Core::url( ROOT_DIR . "/" . UADMIN_ROUTE . "/gateway/{$data['id']}" );

            $data['action'] = "
                <a href='{$href}' class='btn btn-outline-primary mb-1'>
                    <i class='bi bi-pencil'></i>
                </a>

                <a href='?remove={$data['id']}' data-uss-confirm='Sure you want to delete the gateway?' class='btn btn-danger mb-1'>
                    <i class='bi bi-trash'></i>
                </a>
            ";

            return $data;

        }, true);
        

    });

}, null);