<?php
    
    $SQL = SQuery::select( DB_TABLE_PREFIX . "_transfers", "1 ORDER BY id DESC" );

    $result = Uss::$global['mysqli']->query( $SQL );

    # Tablet;

    $tablet = new DOMTablet('transaction');

    $tablet->data( $result );

    $tablet->columns([
        'tx_ref' => 'reference',
        'bank_name' => "Institution",
        'tx_region' => 'region',
        'amount',
        'from' => 'from (debit)',
        'to' => 'to (credit)',
        'tx_date' => 'date',
        'action' => ''
    ]);

    $tablet->chunk(20);

    $tablet->wrap();

    $table = $tablet->table;
    $table->setAttribute('class', $table->getAttribute('class') . " table-striped" );

    $tablet->prepare(function($data) use($transfer) {

        $recipients = $transfer->getTransferMeta( $data['tx_ref'] );

        $data['from'] = $transfer->getAgent( $recipients['sender'] );
        $data['to'] = $transfer->getAgent( $recipients['receiver'] );

        $data['amount'] = '$' . number_format($data['amount'], 2);

        $get = $_GET;
        $get['remove'] = $data['id'];

        $query = http_build_query( $get );
        $editor = Core::url( ROOT_DIR . "/" . implode("/", Uss::query()) . "/{$data['id']}" );
        
        $data['action'] = "
            <a href='{$editor}' class='btn btn-outline-primary'>
                <i class='bi bi-pen'></i>
            </a>
            <a href='?{$query}' class='btn btn-danger' data-uss-confirm='The transaction will be deleted! <br/> Click <span class=\"text-primary\">OK</span> to proceed'>
                <i class='bi bi-trash'></i>
            </a>
        ";

        $data['tx_ref'] = "
            <div class='text-truncate' style='max-width: 100px;'>
                <a href='{$editor}'>{$data['tx_ref']}</a>
            </div>
        ";

        return $data;

    }, true);


?>