"use strict";

$(function() {

    new class {

        templateHTML

        constructor() {

            this.template = $("[data-template='editor']").get(0);

            this.templateHTML = this.template.content.children[0].outerHTML;
            
            this.editContent();

        }

        editContent() {

            const __class__ = this;

            $('#dt-deposits').on('click', '[data-decoder]', function() {

                let decoder = this.dataset.decoder;
                let data = JSON.parse( atob(decoder) );
                let template = __class__.templateHTML;

                for( let x in data ) {
                    let value = data[x];
                    if( x == 'paid' ) {
                        value = Number(value) ? "Yes" : "No";
                    };
                    template = template.replace(`{{${x}}}`, value);
                };

                bootbox.dialog({
                    message: template,
                    onShow: function(e) {
                        __class__.loadTable( data.detail, $(this).find("[data-detail] tbody").get(0) );
                        let select = $(this).find("[data-status]");
                        select.val( select.attr('value') );
                    }
                });

            });

        }

        loadTable( detail, tbody ) {
            let template = $("[data-template='tr']").get(0).content;
            Object.keys(detail).forEach(function(key) {
                let node = template.cloneNode(true);
                node.querySelector('[data-key]').innerText = key.replace('_', ' ');
                node.querySelector('[data-value]').innerText = detail[key];
                tbody.appendChild( node );
            });
        }

    }

});